﻿PRINT N'Validando compatibility level...';

GO
DECLARE @level tinyint;
DECLARE @dbname nvarchar(128);
SET @dbname = DB_NAME();
SELECT @level = [compatibility_level] FROM sys.databases WHERE name = @dbname;

IF @level < 100
BEGIN
    EXEC sp_dbcmptlevel @dbname, 100
END
GO

PRINT N'Creando [dbo].[H_Mapeo_TableType]...';


GO
CREATE TYPE [dbo].[H_Mapeo_TableType] AS TABLE (
    [ID]    INT NULL,
    [OldId] INT NULL);


GO
PRINT N'Modificando [dbo].[Formulario]...';


GO
ALTER TABLE [dbo].[Formulario]
    ADD [Titulo] VARCHAR (250) NULL;


GO
PRINT N'Modificando [dbo].[Proyecto]...';


GO
ALTER TABLE [dbo].[Proyecto]
    ADD [EsApp] BIT NULL;


GO
PRINT N'Creando [dbo].[H_Actividad]...';


GO
CREATE TABLE [dbo].[H_Actividad] (
    [H_IdActividad]              INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]               INT           NOT NULL,
    [IdActividad]                INT           NOT NULL,
    [IdProceso]                  INT           NOT NULL,
    [IdFormulario]               INT           NULL,
    [IdActividadPectra]          INT           NOT NULL,
    [DescripcionActividadPectra] VARCHAR (250) NULL
);


GO
PRINT N'Creando [dbo].[H_Atributo]...';


GO
CREATE TABLE [dbo].[H_Atributo] (
    [H_IdAtributo]          INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]          INT           NOT NULL,
    [IdAtributo]            INT           NOT NULL,
    [IdProceso]             INT           NULL,
    [IdOrigenDeDatosTabla]  INT           NULL,
    [IdOrigenDeDatosVista]  INT           NULL,
    [IdAtributoRelacionado] INT           NULL,
    [Nombre]                VARCHAR (150) NOT NULL,
    [TipoAtributo]          VARCHAR (50)  NOT NULL,
    [TipoDeDato]            VARCHAR (50)  NULL,
    [EsClavePrimaria]       BIT           NULL,
    [Identidad]             BIT           NULL,
    [PermiteNulo]           BIT           NULL
);


GO
PRINT N'Creando [dbo].[H_Formulario]...';


GO
CREATE TABLE [dbo].[H_Formulario] (
    [H_IdFormulario] INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]   INT           NOT NULL,
    [IdFormulario]   INT           NOT NULL,
    [Nombre]         VARCHAR (250) NOT NULL,
    [Definicion]     XML           NULL,
    [Finalizado]     BIT           NOT NULL,
    [Titulo]         VARCHAR (250) NULL
);


GO
PRINT N'Creando [dbo].[H_OrigenDeDatos]...';


GO
CREATE TABLE [dbo].[H_OrigenDeDatos] (
    [H_IdOrigenDeDatos]     INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]          INT           NOT NULL,
    [IdOrigenDeDatos]       INT           NOT NULL,
    [IdProyecto]            INT           NOT NULL,
    [Servidor]              VARCHAR (150) NOT NULL,
    [UsaSeguridadIntegrada] BIT           NOT NULL,
    [Usuario]               VARCHAR (150) NULL,
    [Password]              VARCHAR (250) NULL,
    [NombreBaseDeDatos]     VARCHAR (150) NOT NULL,
    [Observaciones]         VARCHAR (250) NULL
);


GO
PRINT N'Creando [dbo].[H_OrigenDeDatosTabla]...';


GO
CREATE TABLE [dbo].[H_OrigenDeDatosTabla] (
    [H_IdOrigenDeDatosTabla] INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]           INT           NOT NULL,
    [IdOrigenDeDatosTabla]   INT           NULL,
    [IdOrigenDeDatos]        INT           NOT NULL,
    [NombreTabla]            VARCHAR (150) NOT NULL
);


GO
PRINT N'Creando [dbo].[H_OrigenDeDatosVista]...';


GO
CREATE TABLE [dbo].[H_OrigenDeDatosVista] (
    [H_IdOrigenDeDatosVista] INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]           INT           NOT NULL,
    [IdOrigenDeDatosVista]   INT           NULL,
    [IdOrigenDeDatos]        INT           NOT NULL,
    [NombreVista]            VARCHAR (150) NOT NULL
);


GO
PRINT N'Creando [dbo].[H_Proceso]...';


GO
CREATE TABLE [dbo].[H_Proceso] (
    [H_IdProceso]   INT           IDENTITY (1, 1) NOT NULL,
    [H_IdProyecto]  INT           NOT NULL,
    [IdProceso]     INT           NOT NULL,
    [IdProyecto]    INT           NOT NULL,
    [Nombre]        VARCHAR (150) NOT NULL,
    [Descripcion]   VARCHAR (250) NULL,
    [Definicion]    IMAGE         NOT NULL,
    [NombreArchivo] VARCHAR (150) NOT NULL
);


GO
PRINT N'Creando [dbo].[H_Proyecto]...';


GO
CREATE TABLE [dbo].[H_Proyecto] (
    [H_IdProyecto]     INT           IDENTITY (1, 1) NOT NULL,
    [IdProyecto]       INT           NOT NULL,
    [Nombre]           VARCHAR (150) NOT NULL,
    [FechaInicio]      DATETIME      NULL,
    [FechaFinEstimada] DATETIME      NULL,
    [FechaFin]         DATETIME      NULL,
    [Responsable]      VARCHAR (150) NULL,
    [Estado]           VARCHAR (50)  NOT NULL,
    [FechaBack]        DATETIME      NULL,
    [Version]          INT           NULL,
    CONSTRAINT [PK_H_Proyecto] PRIMARY KEY CLUSTERED ([H_IdProyecto] ASC)
);


GO
PRINT N'Creando [dbo].[H_Proyecto].[IX_H_Proyecto_IdProyecto]...';


GO
CREATE NONCLUSTERED INDEX [IX_H_Proyecto_IdProyecto]
    ON [dbo].[H_Proyecto]([IdProyecto] ASC)
    INCLUDE([FechaBack], [Version]);


GO
PRINT N'Modificando [dbo].[Formulario_i]...';


GO
	       --------------------------------------------------------------------------------------------
	        -- Author     :		 samansilla
	        -- Date       :	   2011-03-21T10:09:10
	        -- Description: 	 Procedimiento de creación de Formulario.
	        --------------------------------------------------------------------------------------------
	ALTER PROCEDURE [dbo].[Formulario_i]
	
	(	@IdFormulario int OUTPUT,
	@Nombre varchar(250) ,
	@Titulo varchar(250) ,
	@Definicion xml,
	@Finalizado bit 
)
	
	AS
					
					
	
INSERT INTO Formulario
(
Nombre
,Titulo
,Definicion
,Finalizado


)
VALUES
(
	@Nombre,
	@titulo,
	@Definicion,
	@Finalizado

)
  
				
	        Set @IdFormulario = @@Identity
GO
PRINT N'Modificando [dbo].[Formulario_u]...';


GO
	       --------------------------------------------------------------------------------------------
	        -- Author     :		 samansilla
	        -- Date       :	   2011-03-21T10:09:10
	        -- Description: 	 Procedimiento de actualización de Formulario.
	        --------------------------------------------------------------------------------------------
	ALTER PROCEDURE [dbo].[Formulario_u]
	
	(	@IdFormulario int ,
	@Nombre varchar(250) ,
	@Titulo varchar(250) ,
	@Definicion xml,
	@Finalizado bit 
	
)
	
	AS
					
					
	
UPDATE Formulario
SET 
Nombre = @Nombre,
Titulo = @Titulo, 
Definicion = @Definicion,
Finalizado = @Finalizado

WHERE IdFormulario = @IdFormulario
GO
PRINT N'Modificando [dbo].[Proyecto_i]...';


GO
--------------------------------------------------------------------------------------------
	        -- Author     :		 samansilla
	        -- Date       :	   2011-02-09T09:59:54
	        -- Description: 	 Procedimiento de creación de Proyecto.
	        --------------------------------------------------------------------------------------------
	ALTER PROCEDURE [dbo].[Proyecto_i]
	
	(	@IdProyecto int OUTPUT,
	@Nombre varchar(150) ,
	@FechaInicio datetime  = NULL,
	@FechaFinEstimada datetime  = NULL,
	@FechaFin datetime  = NULL,
	@Responsable varchar(150)  = NULL,
	@Estado varchar(50) ,
	@EsApp bit = null
)
	
	AS
					
					
	
INSERT INTO Proyecto
(
Nombre
,FechaInicio
,FechaFinEstimada
,FechaFin
,Responsable
,Estado
,EsApp

)
VALUES
(
	@Nombre,
	@FechaInicio,
	@FechaFinEstimada,
	@FechaFin,
	@Responsable,
	@Estado,
	@EsApp

)
  
				
	        Set @IdProyecto = @@Identity
GO
PRINT N'Modificando [dbo].[Proyecto_s]...';


GO
--------------------------------------------------------------------------------------------
	        -- Author     :		 samansilla
	        -- Date       :	   2011-02-09T09:59:54
	        -- Description: 	 Procedimiento de búsqueda de Proyecto.
	        --------------------------------------------------------------------------------------------
	ALTER PROCEDURE [dbo].[Proyecto_s]
	
	
	
	AS
					
					
	
  SELECT
  IdProyecto
,Nombre
,FechaInicio
,FechaFinEstimada
,FechaFin
,Responsable
,Estado
,EsApp

  FROM Proyecto
GO
PRINT N'Modificando [dbo].[Atributo_d]...';


GO
--------------------------------------------------------------------------------------------
-- Author     :		 samansilla
-- Date       :	   2011-02-14T17:31:51
-- Description: 	 Procedimiento de eliminación de Atributo.
--------------------------------------------------------------------------------------------
	ALTER PROCEDURE [dbo].[Atributo_d]
	
	(	@IdAtributo int 
)
	
	AS
					


UPDATE Atributo
set IdAtributoRelacionado = null
where IdAtributoRelacionado  = @IdAtributo
					
	
DELETE FROM Atributo
WHERE IdAtributo = @IdAtributo
GO
PRINT N'Modificando [dbo].[Proceso_u]...';


GO
---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------
--------------------------------------------------------------------------------------------
	        -- Author     :		 samansilla
	        -- Date       :	   2011-02-09T09:59:54
	        -- Description: 	 Procedimiento de actualización de Proceso.
	        --------------------------------------------------------------------------------------------
	ALTER  PROCEDURE [dbo].[Proceso_u]
	
	(	@IdProceso int ,
	@IdProyecto int ,
	@Nombre varchar(150) ,
	@Descripcion varchar(250)  = NULL,
	@Definicion image,  
	@NombreArchivo varchar(150) 
)
	
	AS
					
					
	
UPDATE Proceso
SET 
IdProyecto = @IdProyecto,
Nombre = @Nombre,
Descripcion = @Descripcion,
Definicion = @Definicion,
NombreArchivo = @NombreArchivo

WHERE IdProceso = @IdProceso
GO
PRINT N'Modificando [dbo].[Proyecto_g]...';


GO
--------------------------------------------------------------------------------------------
        -- Autor:		samansilla
        -- Creacion:		09/02/2011 09:59:54 a.m.
        -- Descripcion: 	Realiza una busqueda por parametros de la tabla Proyecto
        --------------------------------------------------------------------------------------------
        -- Operadores posibles de usar:
        --
        -- <> | > | >= | < | <= | = | %_ | _% | %% | []
        --
        --------------------------------------------------------------------------------------------
        ALTER PROCEDURE [dbo].[Proyecto_g]
	        -- Lista de Parámetros
	        @OrdenDeRegistros 					    VARCHAR(100) = null,
        	@IdProyecto int = NULL,

	@Nombre varchar(150) = NULL,

	--@FechaInicioDesde datetime  = NULL,

	--@FechaInicioHasta datetime  = NULL,
	@FechaInicio datetime  = NULL,

	--@FechaFinEstimadaDesde datetime  = NULL,

	--@FechaFinEstimadaHasta datetime  = NULL,
	@FechaFinEstimada datetime  = NULL,

	--@FechaFinDesde datetime  = NULL,

	--@FechaFinHasta datetime  = NULL,
	@FechaFin datetime  = NULL,

	@Responsable varchar(150)  = NULL,

	@Estado varchar(50) = NULL,

	@EsApp bit = null

        AS
        BEGIN
	        SET NOCOUNT ON
	        SET DATEFORMAT DMY

	        ----------------------------------------
	        -- Definimos Variables
	        ----------------------------------------
	        DECLARE @sql        nvarchar(4000)
	        DECLARE @parametros nvarchar(4000)

	        SET @sql = N' SELECT * FROM Proyecto  WHERE 1 = 1 '

        
				-- IdProyecto = TYPE int
            IF (@IdProyecto IS NOT NULL)
            BEGIN
			        SET @sql = @sql + ' AND IdProyecto =  @IdProyecto '
            END
					

				-- Nombre = TYPE varchar
             IF (@Nombre IS NOT NULL)
             BEGIN
			        SET @sql = @sql + ' AND Nombre  LIKE  @Nombre '
             END
					

						  -- FechaInicio = TYPE datetime
           
				           -- IF (@FechaInicioDesde IS NOT NULL AND @FechaInicioDesde <> '' AND 
				             --   @FechaInicioHasta IS NOT NULL AND @FechaInicioHasta <> '')
                  --BEGIN	
					          --  SET @sql = @sql + ' AND (FechaInicio >= @FechaInicioDesde AND FechaInicio <= @FechaInicioHasta)'
                  --END
			        -- FechaInicio = TYPE datetime
               IF (@FechaInicio IS NOT NULL)
                BEGIN
			            SET @sql = @sql + ' AND FechaInicio  =   @FechaInicio ' 
                END
		           
					

						  -- FechaFinEstimada = TYPE datetime
           
				           -- IF (@FechaFinEstimadaDesde IS NOT NULL AND @FechaFinEstimadaDesde <> '' AND 
				             --   @FechaFinEstimadaHasta IS NOT NULL AND @FechaFinEstimadaHasta <> '')
                  --BEGIN	
					          --  SET @sql = @sql + ' AND (FechaFinEstimada >= @FechaFinEstimadaDesde AND FechaFinEstimada <= @FechaFinEstimadaHasta)'
                  --END
			        -- FechaFinEstimada = TYPE datetime
               IF (@FechaFinEstimada IS NOT NULL)
                BEGIN
			            SET @sql = @sql + ' AND FechaFinEstimada  =   @FechaFinEstimada ' 
                END
		           
					

						  -- FechaFin = TYPE datetime
           
				           -- IF (@FechaFinDesde IS NOT NULL AND @FechaFinDesde <> '' AND 
				             --   @FechaFinHasta IS NOT NULL AND @FechaFinHasta <> '')
                  --BEGIN	
					          --  SET @sql = @sql + ' AND (FechaFin >= @FechaFinDesde AND FechaFin <= @FechaFinHasta)'
                  --END
			        -- FechaFin = TYPE datetime
               IF (@FechaFin IS NOT NULL)
                BEGIN
			            SET @sql = @sql + ' AND FechaFin  =   @FechaFin ' 
                END
		           
					

				-- Responsable = TYPE varchar
             IF (@Responsable IS NOT NULL)
             BEGIN
			        SET @sql = @sql + ' AND Responsable  LIKE  @Responsable '
             END
					

				-- Estado = TYPE varchar
             IF (@Estado IS NOT NULL)
             BEGIN
			        SET @sql = @sql + ' AND Estado  LIKE  @Estado '
             END

			 	-- EsApp = TYPE bit
             IF (@EsApp IS NOT NULL)
             BEGIN
				IF (@EsApp = 0)
			        SET @sql = @sql + ' AND (EsApp  =  0 or  EsApp is null)'
				else
				    SET @sql = @sql + ' AND (EsApp  =  1)'

             END
					

	        IF (@OrdenDeRegistros IS NOT NULL AND @OrdenDeRegistros <> '')
	        BEGIN
		        SET @sql = @sql + ' ORDER BY ' + @OrdenDeRegistros
	        END

	        SELECT @parametros = '	@IdProyecto int ,

	@Nombre varchar(150) ,

	--@FechaInicioDesde datetime  = NULL,

	--@FechaInicioHasta datetime  = NULL,
	@FechaInicio datetime  = NULL,

	--@FechaFinEstimadaDesde datetime  = NULL,

	--@FechaFinEstimadaHasta datetime  = NULL,
	@FechaFinEstimada datetime  = NULL,

	--@FechaFinDesde datetime  = NULL,

	--@FechaFinHasta datetime  = NULL,
	@FechaFin datetime  = NULL,

	@Responsable varchar(150)  = NULL,

	@Estado varchar(50),
	
	 @EsApp bit'

	        EXEC sp_executesql @sql, @parametros, @IdProyecto, @Nombre, 
--@FechaInicioDesde, 
--@FechaInicioHasta, 
@FechaInicio, 
--@FechaFinEstimadaDesde, 
--@FechaFinEstimadaHasta, 
@FechaFinEstimada, 
--@FechaFinDesde, 
--@FechaFinHasta, 
@FechaFin, @Responsable, @Estado, @EsApp
        END
GO
PRINT N'Creando [dbo].[Atributo_d_ByIdOrigenDeDatosTabla]...';


GO

create PROCEDURE [dbo].Atributo_d_ByIdOrigenDeDatosTabla
	
	(	@idOrigenDeDatosTabla int 
)
	
	AS
					
					
	
DELETE FROM Atributo
WHERE idOrigenDeDatosTabla = @idOrigenDeDatosTabla
GO
PRINT N'Creando [dbo].[Formulario_Atributos_OK]...';


GO
 CREATE PROCEDURE [dbo].[Formulario_Atributos_OK]

@IdProceso int,
@IdFormulario int 

 AS


 
DECLARE @Xml xml
DECLARE @TablaIdsEnformulario	TABLE (ID Int);
DECLARE @Id INT

SELECT @Xml = cast(Definicion as XML)  FROM [Formulario] WHERE IdFormulario= @IdFormulario

INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdAtributoCampo[1]',		'NVARCHAR(20)') FROM		@Xml.nodes('//OrigenDatos') AS T(C) 
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdAtributoCampo[1]',		'NVARCHAR(20)')	FROM		@Xml.nodes('//OrigenDatos') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('ClaveExternaIdAtributo[1]','NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('CampoValorIdAtributo[1]',	'NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampoMostrar[1]',		'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampoValor[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampo[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//CampoMostrarGrilla') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampo[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//CampoMostrarBusqueda') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampoMostrar[1]',		'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampoValor[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
INSERT	@TablaIdsEnformulario (ID) SELECT	C.value('IdCampoFiltro[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	


select top 1 @Id = Id from @TablaIdsEnformulario
where id is not null
and Id not in (select IdAtributo from Atributo where IdProceso = @IdProceso)

select  Id from @TablaIdsEnformulario

select @Id

if @Id is null
	select 1 as 'Estado'
else
	select 0 as 'Estado'
GO
PRINT N'Creando [dbo].[Formulario_g_ByIdProceso_ConErrores]...';


GO

CREATE procedure Formulario_g_ByIdProceso_ConErrores
(
@IdProceso		int
)

AS

declare @IdFormulario		int


DECLARE @TablaAtributosEnFormularios		TABLE (Id int identity(1,1),  IdFormulario int, IdAtributo varchar(20), Nombre varchar(200))
DECLARE @Xml xml



DECLARE @Formularios				TABLE (Id int identity(1,1), IdFormulario int,Procesado	bit DEFAULT 0)

INSERT @Formularios (IdFormulario)
	SELECT IdFormulario from Actividad 
		WHERE IdProceso = @IdProceso

While (Select Count(*) From @Formularios Where Procesado = 0) > 0
	Begin
	
		Update top (1) @Formularios Set Procesado = 1, @IdFormulario = IdFormulario WHERE Procesado = 0

		SELECT @Xml = cast(Definicion as XML)  FROM [Formulario] WHERE IdFormulario = @IdFormulario

		
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdAtributoCampo[1]',			'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('AtributoCampo[1]',		'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//OrigenDatos') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('ClaveExternaIdAtributo[1]',		'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('ClaveExternaNombre[1]',	'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('CampoValorIdAtributo[1]',		'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('CampoValorNombre[1]',	'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoMostrar[1]',				'NVARCHAR(20)'), isnull(C.value('../../Nombre[1]',		'NVARCHAR(120)'), '') + ' (' + C.value('CampoMostrar[1]',		'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoValor[1]',				'NVARCHAR(20)'), isnull(C.value('../../Nombre[1]',		'NVARCHAR(120)'), '') + ' (' + C.value('CampoValor[1]',			'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampo[1]',					'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('NombreCampo[1]',			'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//CampoMostrarGrilla') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampo[1]',					'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('NombreCampo[1]',			'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//CampoMostrarBusqueda') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoMostrar[1]',				'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('CampoMostrar[1]',		'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//Control') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoValor[1]',				'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('CampoValor[1]',			'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//Control') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoFiltro[1]',				'NVARCHAR(20)'), isnull(C.value('../Nombre[1]',			'NVARCHAR(120)'), '') + ' (' + C.value('CampoFiltro[1]',			'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//Control') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoFiltro[1]',				'NVARCHAR(20)'), isnull(C.value('../../Nombre[1]',		'NVARCHAR(120)'), '') + ' (' + C.value('CampoFiltro[1]',			'NVARCHAR(120)') + ')'	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
		
	
	/*

		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdAtributoCampo[1]',			'NVARCHAR(20)'), C.value('AtributoCampo[1]',		'NVARCHAR(20)')	FROM		@Xml.nodes('//OrigenDatos') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('ClaveExternaIdAtributo[1]',		'NVARCHAR(20)'), C.value('ClaveExternaNombre[1]',	'NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('CampoValorIdAtributo[1]',		'NVARCHAR(20)'), C.value('CampoValorNombre[1]',		'NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoMostrar[1]',				'NVARCHAR(20)'), C.value('CampoMostrar[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoValor[1]',				'NVARCHAR(20)'), C.value('CampoValor[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampo[1]',					'NVARCHAR(20)'), C.value('NombreCampo[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//CampoMostrarGrilla') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampo[1]',					'NVARCHAR(20)'), C.value('NombreCampo[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//CampoMostrarBusqueda') AS T(C)	

		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoMostrar[1]',				'NVARCHAR(20)'), C.value('CampoMostrar[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoValor[1]',				'NVARCHAR(20)'), C.value('CampoValor[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoFiltro[1]',				'NVARCHAR(20)'), C.value('CampoFiltro[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
		INSERT	@TablaAtributosEnFormularios (IdFormulario, IdAtributo, Nombre)	SELECT	@IdFormulario, C.value('IdCampoFiltro[1]',				'NVARCHAR(20)'), C.value('CampoFiltro[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
		*/
	End

select IdFormulario, IdAtributo, Nombre from @TablaAtributosEnFormularios where IdAtributo is not null
and IdAtributo  <> 0
and IdAtributo not in (
SELECT  [IdAtributo]
  FROM [Atributo]
  where 
[IdProceso] = @IdProceso
)  
group by IdFormulario, IdAtributo, Nombre
GO
PRINT N'Creando [dbo].[H_ActualizarDefinicionFormulario]...';


GO


CREATE PROCEDURE [dbo].[H_ActualizarDefinicionFormulario]
(
@IdFormulario		int,
@strMapeoTabla		varchar(max),
@strMapeoVista		varchar(max),
@strMapeoAtributo	varchar(max)
)
AS

--declare @IdFormulario int
--set @IdFormulario = 1697
DECLARE @Xml xml
DECLARE @ValorNuevo as varchar(20)
DECLARE @ValorViejo nvarchar(100)

SELECT @Xml = cast(Definicion as XML)  FROM [Formulario] WHERE IdFormulario=@IdFormulario

DECLARE @Reemplazos_A		TABLE (Id int identity(1,1), Viejo varchar(20), Nuevo varchar(20) DEFAULT '',Procesado	bit DEFAULT 0, Tipo int)
DECLARE @Reemplazos_T		TABLE (Id int identity(1,1), Viejo varchar(20), Nuevo varchar(20) DEFAULT '',Procesado	bit DEFAULT 0, Tipo int)
DECLARE @MapeoTabla			TABLE (T_ID Int, T_OldId Int);
DECLARE @MapeoVista			TABLE (V_ID Int, V_OldId Int);
DECLARE @MapeoAtributo		TABLE (A_ID Int, A_OldId Int);
DECLARE @XMLMapeoTabla		XML
DECLARE @XMLMapeoVista		XML
DECLARE @XMLMapeoAtributo	XML

SET @XMLMapeoTabla		= cast(@strMapeoTabla  as XML)
SET @XMLMapeoVista		= cast(@strMapeoVista  as XML)
SET @XMLMapeoAtributo	= cast(@strMapeoAtributo  as XML)

INSERT @MapeoTabla		SELECT	Tbl.Col.value('@T_Id', 'int'),	Tbl.Col.value('@T_OldId', 'int')	FROM   @XMLMapeoTabla.nodes('//row') Tbl(Col)
INSERT @MapeoVista		SELECT	Tbl.Col.value('@V_Id', 'int'),	Tbl.Col.value('@V_OldId', 'int')	FROM   @XMLMapeoVista.nodes('//row') Tbl(Col)
INSERT @MapeoAtributo	SELECT	Tbl.Col.value('@A_Id', 'int'),	Tbl.Col.value('@A_OldId', 'int')	FROM   @XMLMapeoAtributo.nodes('//row') Tbl(Col)

---------------------------
--	OrigenDatos	- IdAtributoCampo
---------------------------
 --Obtengo campos con valores a cambiar
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		1,	C.value('IdAtributoCampo[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//OrigenDatos') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		2,	C.value('ClaveExternaIdAtributo[1]',	'NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		3,	C.value('CampoValorIdAtributo[1]',		'NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		4,	C.value('IdCampoMostrar[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		5,	C.value('IdCampoValor[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		6,	C.value('IdCampo[1]',					'NVARCHAR(20)')	FROM		@Xml.nodes('//CampoMostrarGrilla') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		7,	C.value('IdCampo[1]',					'NVARCHAR(20)')	FROM		@Xml.nodes('//CampoMostrarBusqueda') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		8,	C.value('IdCampoMostrar[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		9,	C.value('IdCampoValor[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	
INSERT		@Reemplazos_A (Tipo, Viejo)	SELECT		10,	C.value('IdCampoFiltro[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	

INSERT		@Reemplazos_T (Tipo, Viejo)	SELECT		100,	C.value('IdOrigenDatos[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//OrigenDatos') AS T(C)	
INSERT		@Reemplazos_T (Tipo, Viejo)	SELECT		101,	C.value('IdOrigenDatos[1]',			'NVARCHAR(20)')	FROM		@Xml.nodes('//DestinoDatos') AS T(C)	
INSERT		@Reemplazos_T (Tipo, Viejo)	SELECT		102,	C.value('IdTabla[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//ListaDinamica') AS T(C)	
INSERT		@Reemplazos_T (Tipo, Viejo)	SELECT		103,	C.value('IdTabla[1]',				'NVARCHAR(20)')	FROM		@Xml.nodes('//Control') AS T(C)	

DELETE FROM @Reemplazos_A where Viejo is null or Viejo = ''
DELETE FROM @Reemplazos_T where Viejo is null or Viejo = ''

UPDATE @Reemplazos_A set Nuevo = A.A_ID	from @Reemplazos_A R inner join @MapeoAtributo A on A_OldId = R.Viejo
UPDATE @Reemplazos_T set Nuevo = T.T_ID	from @Reemplazos_T R inner join @MapeoTabla	   T on T_OldId = R.Viejo

DELETE FROM @Reemplazos_A where Nuevo is null or Nuevo = ''
DELETE FROM @Reemplazos_T where Nuevo is null or Nuevo = ''


select * from @Reemplazos_A
select * from @Reemplazos_T

--Hago Cambios 
While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 1) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//OrigenDatos[IdAtributoCampo= sql:variable("@ValorViejo") ]/IdAtributoCampo/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '1.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End
While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 2) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//DestinoDatos[ClaveExternaIdAtributo= sql:variable("@ValorViejo") ]/ClaveExternaIdAtributo/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '2.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End
While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 3) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//DestinoDatos[CampoValorIdAtributo= sql:variable("@ValorViejo") ]/CampoValorIdAtributo/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '3.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End
While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 4) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//ListaDinamica[IdCampoMostrar= sql:variable("@ValorViejo") ]/IdCampoMostrar/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '4.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End
While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 5) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//ListaDinamica[IdCampoValor= sql:variable("@ValorViejo") ]/IdCampoValor/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '5.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End

While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 6) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//CampoMostrarGrilla[IdCampo= sql:variable("@ValorViejo") ]/IdCampo/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '6.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End

While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 7) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//CampoMostrarBusqueda[IdCampo= sql:variable("@ValorViejo") ]/IdCampo/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '7.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End	

While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 8) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//Control[IdCampoMostrar= sql:variable("@ValorViejo") ]/IdCampoMostrar/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '8.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End	

While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 9) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//Control[IdCampoValor= sql:variable("@ValorViejo") ]/IdCampoValor/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '9.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End	

While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 10) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//Control[IdCampoFiltro= sql:variable("@ValorViejo") ]/IdCampoFiltro/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '10.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End	
/*	
While (Select Count(*) From @Reemplazos_A Where Procesado = 0 and Tipo = 11) > 0
	Begin
		Update top (1) @Reemplazos_A Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//ListaDinamica[IdCampoFiltro= sql:variable("@ValorViejo") ]/IdCampoFiltro/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '11.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End	
	*/

	
While (Select Count(*) From @Reemplazos_T Where Procesado = 0 and Tipo = 100) > 0
	Begin
		Update top (1) @Reemplazos_T Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//OrigenDatos[IdOrigenDatos= sql:variable("@ValorViejo") ]/IdOrigenDatos/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '10.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End


While (Select Count(*) From @Reemplazos_T Where Procesado = 0 and Tipo = 101) > 0
	Begin
		Update top (1) @Reemplazos_T Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//DestinoDatos[IdOrigenDatos= sql:variable("@ValorViejo") ]/IdOrigenDatos/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '11.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End
	
While (Select Count(*) From @Reemplazos_T Where Procesado = 0 and Tipo = 102) > 0
	Begin
		Update top (1) @Reemplazos_T Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//ListaDinamica[IdTabla= sql:variable("@ValorViejo") ]/IdTabla/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '12.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End
	
While (Select Count(*) From @Reemplazos_T Where Procesado = 0 and Tipo = 103) > 0
	Begin
		Update top (1) @Reemplazos_T Set Procesado = 1, @ValorNuevo = Nuevo, @ValorViejo = Viejo WHERE Procesado = 0
		SET @Xml.modify( 'replace value of (//Control[IdTabla= sql:variable("@ValorViejo") ]/IdTabla/text())[1] with sql:variable("@ValorNuevo")')
		PRINT '12.se actualiza: ' + @ValorViejo + ' por :' + @ValorNuevo
	End


	update Formulario set Definicion = @Xml Where IdFormulario = @IdFormulario
--select cast(@Xml as varchar(max))
GO
PRINT N'Creando [dbo].[H_ClonarBackUp]...';


GO
CREATE PROCEDURE [dbo].[H_ClonarBackUp]
(
 @H_IdProyecto int,
 @Responsable varchar(150) = ''
)

AS

declare @IdProyecto int
declare @IdProceso int
declare @IdOrigenDeDatos int

declare @H_IdProceso int
declare @H_IdOrigenDeDatos int

DECLARE @MapeoOrigenDeDatosTabla TABLE (T_ID Int, T_OldId Int);
DECLARE @MapeoOrigenDeDatosVista TABLE (V_ID Int, V_OldId Int);
DECLARE @MapeoFormulario TABLE (F_ID Int, F_OldId Int);
DECLARE @MapeoAtributo TABLE (A_ID Int, A_OldId Int);


---------------------
--- Proyecto
---------------------
INSERT INTO		Proyecto
                         ( Nombre, FechaInicio, FechaFinEstimada, Responsable, Estado, EsApp)
--SELECT  TOP (1)  Nombre + '_Restaurado_De_' + replace(replace(replace(convert(nvarchar(19), fechaBack, 20), ':','_'), '-','_'), ' ','_')
SELECT  TOP (1)  Nombre + '_' + convert(nvarchar(19), IdProyecto, 20) + '.' + convert(nvarchar(19), [version], 20)
, getdate(),  dateadd(yy, 50, getdate()), @Responsable, 'iniciado', 1
FROM    H_Proyecto
where	H_IdProyecto = @H_IdProyecto

set @IdProyecto = @@IDENTITY


---------------------
---- OrigenDeDatos
---------------------

SELECT TOP (1) @H_IdOrigenDeDatos = H_IdOrigenDeDatos
FROM    H_OrigenDeDatos
where	H_IdProyecto = @H_IdProyecto

if @H_IdOrigenDeDatos is not null 
	BEGIN
		INSERT INTO OrigenDeDatos
								 (IdProyecto, Servidor, UsaSeguridadIntegrada, Usuario, Password, NombreBaseDeDatos, Observaciones)
		SELECT      @IdProyecto, Servidor, UsaSeguridadIntegrada, Usuario, Password, NombreBaseDeDatos, Observaciones
		FROM        H_OrigenDeDatos
		WHERE		H_IdOrigenDeDatos = @H_IdOrigenDeDatos

		set @IdOrigenDeDatos = @@IDENTITY;

	END


---------------------
---- OrigenDeDatosTabla
---------------------

if @H_IdOrigenDeDatos is not null 
	BEGIN

		MERGE INTO OrigenDeDatosTabla
		USING H_OrigenDeDatosTabla AS cf
		ON 1 = 0 -- Ensure never match - therefore an Insert
		WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto THEN
  
		INSERT		 (IdOrigenDeDatos, NombreTabla)
		values       (@IdOrigenDeDatos, cf.NombreTabla)
  
		Output inserted.IdOrigenDeDatosTabla, cf.IdOrigenDeDatosTabla INTO 
		@MapeoOrigenDeDatosTabla(T_Id, T_OldId);

		
		select 'insert into @MapeoOrigenDeDatosTabla select ' + cast(T_Id as varchar(290)) + ', ' + cast(T_OldId as varchar(20)) from @MapeoOrigenDeDatosTabla order by 1 desc


	END
	
---------------------
---- OrigenDeDatosVista
---------------------

if @H_IdOrigenDeDatos is not null 
	BEGIN

		MERGE INTO OrigenDeDatosVista
		USING H_OrigenDeDatosVista AS cf
		ON 1 = 0 -- Ensure never match - therefore an Insert
		WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto THEN
  
		INSERT		 (IdOrigenDeDatos, NombreVista)
		values       (@IdOrigenDeDatos, cf.NombreVista)
  
		Output inserted.IdOrigenDeDatosVista, cf.IdOrigenDeDatosVista INTO 
		@MapeoOrigenDeDatosVista(V_Id, V_OldId);

		  
		--select 'insert into @MapeoOrigenDeDatosVista select ' + cast(V_Id as varchar(290)) + ', ' + cast(V_OldId as varchar(20)) from @MapeoOrigenDeDatosVista order by 1 desc

	END

---------------------
---- Proceso
---------------------

SELECT TOP (1) @H_IdProceso = H_IdProceso
FROM    H_Proceso
where	H_IdProyecto = @H_IdProyecto


if @H_IdProceso is not null 
	BEGIN
		INSERT INTO Proceso
								 (IdProyecto, Nombre, Descripcion, Definicion, NombreArchivo)
		SELECT      TOP (1) @IdProyecto, Nombre, Descripcion, Definicion, NombreArchivo
		FROM        H_Proceso 
		WHERE		H_IdProceso = @H_IdProceso
	
	
		set @IdProceso = @@IDENTITY;
	END
	

	
---------------------
---- Formulario
---------------------
if @H_IdProceso is not null 
	BEGIN

		MERGE INTO Formulario
		USING H_Formulario AS cf
		ON 1 = 0 -- Ensure never match - therefore an Insert
		WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto THEN
  
		INSERT		 (Nombre, Definicion, Finalizado, Titulo)
		values       (cf.Nombre, cf.Definicion, cf.Finalizado, cf.Titulo)
  
		Output inserted.IdFormulario, cf.H_IdFormulario INTO 
		@MapeoFormulario(F_Id, F_OldId);

	END

		
---------------------
---- Actividad
---------------------
if @H_IdProceso is not null 
	BEGIN
		INSERT INTO Actividad
				(IdProceso, IdFormulario, IdActividadPectra, DescripcionActividadPectra)

		SELECT	@IdProceso, [F_ID] as IdFormulario, HA.IdActividadPectra, HA.DescripcionActividadPectra 
		FROM	[H_Actividad] HA
			left outer join H_Formulario HF on HF.[IdFormulario] = HA.[IdFormulario]
			and HF.H_IdProyecto = HA.H_IdProyecto
			left outer join @MapeoFormulario MF
		on MF.F_OldId = HF.H_IdFormulario
		WHERE	HA.H_IdProyecto = @H_IdProyecto 
	END
	
---------------------
---- Atributo
---------------------

if @H_IdProceso is not null 
	BEGIN
	----------------
	-- Att de Pectra
	----------------

		MERGE INTO Atributo
			USING H_Atributo AS cf
			ON 1 = 0 -- Ensure never match - therefore an Insert
			WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto 
							 AND cf.TipoAtributo = 'pectra'		THEN
  
			INSERT		 (IdProceso,  Nombre, TipoAtributo)
			values       (@IdProceso, cf.Nombre, cf.TipoAtributo)
			  
			Output inserted.IdAtributo, cf.IdAtributo INTO 
			@MapeoAtributo(A_Id, A_OldId);


			--select 'insert into @MapeoAtributo select ' + cast(A_Id as varchar(290)) + ', ' + cast(A_OldId as varchar(20)) from @MapeoAtributo order by 1 desc

	----------------
	-- Att de Base de Datos
	----------------
	/*
	INSERT INTO Atributo
		(IdProceso, IdOrigenDeDatosTabla, IdOrigenDeDatosVista, IdAtributoRelacionado, Nombre, TipoAtributo, TipoDeDato, EsClavePrimaria, Identidad, PermiteNulo)

	SELECT @IdProceso, T_ID as IdOrigenDeDatosTabla, V_ID as IdOrigenDeDatosVista, A_ID as IdAtributoRelacionado, HA.Nombre, HA.TipoAtributo, HA.TipoDeDato, HA.EsClavePrimaria, HA.Identidad, HA.PermiteNulo
		  FROM [H_Atributo] HA

		  left outer join @MapeoOrigenDeDatosTabla	MT on HA.IdOrigenDeDatosTabla = MT.T_OldId
		  left outer join @MapeoOrigenDeDatosVista	MV on HA.IdOrigenDeDatosVista = MV.V_OldId
		  left outer join @MapeoAtributo			MA on HA.IdAtributoRelacionado = MA.A_OldId

		  WHERE  HA.H_IdProyecto = @H_IdProyecto
		  AND HA.TipoAtributo = 'Database'
		  ORDER BY 1 desc
		  */

  
  	SELECT @IdProceso as IdProceso, T_ID as IdOrigenDeDatosTabla, V_ID as IdOrigenDeDatosVista, A_ID as IdAtributoRelacionado, HA.Nombre, HA.TipoAtributo, HA.TipoDeDato, HA.EsClavePrimaria, HA.Identidad, HA.PermiteNulo, HA.IdAtributo
		    into #TempAttDB
			FROM [H_Atributo] HA

		  left outer join @MapeoOrigenDeDatosTabla	MT on HA.IdOrigenDeDatosTabla = MT.T_OldId
		  left outer join @MapeoOrigenDeDatosVista	MV on HA.IdOrigenDeDatosVista = MV.V_OldId
		  left outer join @MapeoAtributo			MA on HA.IdAtributoRelacionado = MA.A_OldId
		
		  WHERE  HA.H_IdProyecto = @H_IdProyecto
		  AND HA.TipoAtributo = 'Database'


		  
		MERGE INTO Atributo
			USING #TempAttDB AS cf
			ON 1 = 0 -- Ensure never match - therefore an Insert
			WHEN NOT MATCHED 	THEN
  
			INSERT		 (IdProceso, IdOrigenDeDatosTabla, IdOrigenDeDatosVista, IdAtributoRelacionado, Nombre, TipoAtributo, TipoDeDato, EsClavePrimaria, Identidad, PermiteNulo)
			values       (cf.IdProceso, cf.IdOrigenDeDatosTabla, cf.IdOrigenDeDatosVista, cf.IdAtributoRelacionado, cf.Nombre, cf.TipoAtributo, cf.TipoDeDato, cf.EsClavePrimaria, cf.Identidad, cf.PermiteNulo)
			  
			Output inserted.IdAtributo, cf.IdAtributo INTO 
			@MapeoAtributo(A_Id, A_OldId);


			select 'insert into @MapeoAtributo select ' + cast(A_Id as varchar(290)) + ', ' + cast(A_OldId as varchar(20)) from @MapeoAtributo order by 1 desc


	END

-----------------------------------
-- Actulizacion de Campo Definicino de los Formularios
-----------------------------------
	
DECLARE @MapeoA varchar(max)
DECLARE @MapeoT varchar(max)

set @MapeoA = CAST((select A_Id, A_OldId from @MapeoAtributo FOR XML raw('row'),root('root') ) AS VARCHAR(MAX));
set @MapeoT = CAST((select T_Id, T_OldId from @MapeoOrigenDeDatosTabla FOR XML raw('row'),root('root') ) AS VARCHAR(MAX));


DECLARE @Formularios				TABLE (Id int identity(1,1), IdFormulario int,Procesado	bit DEFAULT 0)
DECLARE @IdFormularioAReemplazar	INT

INSERT @Formularios (IdFormulario)
	SELECT IdFormulario from Actividad 
		WHERE IdProceso = @IdProceso

While (Select Count(*) From @Formularios Where Procesado = 0) > 0
	Begin
		Update top (1) @Formularios Set Procesado = 1, @IdFormularioAReemplazar = IdFormulario WHERE Procesado = 0
		EXEC H_ActualizarDefinicionFormulario @IdFormularioAReemplazar, @MapeoT, '', @MapeoA
		--PRINT 'SE ACTUALIZA FORMULARIO : ' + cast(@IdFormularioAReemplazar as varchar(20))
		
	End
GO
PRINT N'Creando [dbo].[H_ElevarPermisoMERGE]...';


GO

CREATE PROCEDURE H_ElevarPermisoMERGE
AS
BEGIN
	declare @compatibility_level int;
	SELECT top 1 @compatibility_level = compatibility_level FROM sys.databases where name = 'master';
	declare @sql as nvarchar(500);
	set @sql ='ALTER DATABASE ' + DB_NAME() + ' SET COMPATIBILITY_LEVEL = ' + cast(@compatibility_level as varchar(10))
	EXECUTE sp_executesql @sql

END
GO
PRINT N'Creando [dbo].[H_GenerarBackUp]...';


GO
CREATE PROCEDURE [dbo].[H_GenerarBackUp]
(
 @IdProyecto int
)

AS

declare @H_IdProyecto int
declare @IdProceso int
declare @IdOrigenDeDatos int

---------------------
--- Proyecto
---------------------

DECLARE @Version int
select @Version = isnull(max([Version]), 0) 
	from  H_Proyecto
	where	IdProyecto = @IdProyecto

set @Version = @Version + 1


INSERT INTO H_Proyecto
                         (IdProyecto, Nombre, FechaInicio, FechaFinEstimada, FechaFin, Responsable, Estado,FechaBack, Version)
SELECT  TOP (1) IdProyecto, Nombre, FechaInicio, FechaFinEstimada, FechaFin, Responsable, Estado, getdate(), @Version
FROM    Proyecto
where	IdProyecto = @IdProyecto

set @H_IdProyecto = @@IDENTITY

---------------------
---- OrigenDeDatos
---------------------

SELECT TOP (1) @IdOrigenDeDatos = IdOrigenDeDatos
FROM    OrigenDeDatos
where	IdProyecto = @IdProyecto


if @IdOrigenDeDatos is not null 
	BEGIN
		INSERT INTO H_OrigenDeDatos
								 (H_IdProyecto, IdOrigenDeDatos, IdProyecto, Servidor, UsaSeguridadIntegrada, Usuario, Password, NombreBaseDeDatos, Observaciones)
		SELECT      @H_IdProyecto, IdOrigenDeDatos, IdProyecto, Servidor, UsaSeguridadIntegrada, Usuario, Password, NombreBaseDeDatos, Observaciones
		FROM        OrigenDeDatos
		WHERE		IdOrigenDeDatos = @IdOrigenDeDatos
	END

---------------------
---- OrigenDeDatosTabla
---------------------

if @IdOrigenDeDatos is not null 
	BEGIN
		INSERT INTO H_OrigenDeDatosTabla
								 (H_IdProyecto, IdOrigenDeDatosTabla, IdOrigenDeDatos, NombreTabla)
		SELECT        @H_IdProyecto, IdOrigenDeDatosTabla, IdOrigenDeDatos, NombreTabla
		FROM           OrigenDeDatosTabla
		WHERE		IdOrigenDeDatos = @IdOrigenDeDatos
	END

---------------------
---- OrigenDeDatosVista
---------------------
if @IdOrigenDeDatos is not null 
	BEGIN
		INSERT INTO H_OrigenDeDatosVista
								 (H_IdProyecto, IdOrigenDeDatosVista, IdOrigenDeDatos, NombreVista)
		SELECT        @H_IdProyecto, IdOrigenDeDatosVista, IdOrigenDeDatos, NombreVista
		FROM            OrigenDeDatosVista
		WHERE		IdOrigenDeDatos = @IdOrigenDeDatos
	END

---------------------
---- Proceso
---------------------

SELECT TOP (1) @IdProceso = IdProceso
FROM    Proceso
where	IdProyecto = @IdProyecto


if @IdProceso is not null 
	BEGIN
		INSERT INTO H_Proceso
								 (H_IdProyecto, IdProceso, IdProyecto, Nombre, Descripcion, Definicion, NombreArchivo)
		SELECT      TOP (1) @H_IdProyecto, IdProceso, IdProyecto, Nombre, Descripcion, Definicion, NombreArchivo
		FROM        Proceso 
		WHERE		IdProceso = @IdProceso
	END

---------------------
---- Atributo
---------------------

if @IdProceso is not null 
	BEGIN
		INSERT INTO H_Atributo
								 (H_IdProyecto, IdAtributo, IdProceso, IdOrigenDeDatosTabla, IdOrigenDeDatosVista, IdAtributoRelacionado, Nombre, TipoAtributo, TipoDeDato, EsClavePrimaria, Identidad, PermiteNulo)
		SELECT        @H_IdProyecto, IdAtributo, IdProceso, IdOrigenDeDatosTabla, IdOrigenDeDatosVista, IdAtributoRelacionado, Nombre, TipoAtributo, TipoDeDato, EsClavePrimaria, Identidad, PermiteNulo
		FROM            Atributo
		WHERE		IdProceso = @IdProceso
	END


---------------------
---- Formulario
---------------------
if @IdProceso is not null 
	BEGIN

		INSERT INTO H_Formulario
		                     (H_IdProyecto,IdFormulario, Nombre, Definicion, Finalizado, Titulo)
		SELECT      @H_IdProyecto, IdFormulario, Nombre, Definicion, Finalizado, Titulo
		FROM        Formulario 
		WHERE		IdFormulario in 
				(
					SELECT IdFormulario FROM Actividad
					WHERE		IdProceso = @IdProceso
				)
	END

---------------------
---- Actividad
---------------------
if @IdProceso is not null 
	BEGIN
		INSERT INTO H_Actividad
								 (H_IdProyecto, IdActividad, IdProceso, IdFormulario, IdActividadPectra, DescripcionActividadPectra)
		SELECT        @H_IdProyecto, IdActividad, IdProceso, IdFormulario, IdActividadPectra, DescripcionActividadPectra
		FROM           Actividad
		WHERE		IdProceso = @IdProceso
	END
GO
PRINT N'Creando [dbo].[H_GetVersiones]...';


GO

CREATE PROCEDURE H_GetVersiones
(
 @IdProyecto int
)

AS

select * from H_Proyecto
where	IdProyecto = @IdProyecto
GO
PRINT N'Creando [dbo].[H_RestaurarBackUp]...';


GO
CREATE PROCEDURE [dbo].[H_RestaurarBackUp]
(
 @H_IdProyecto int
)

AS

declare @IdProyecto int
declare @IdProceso int
declare @IdOrigenDeDatos int

declare @H_IdProceso int
declare @H_IdOrigenDeDatos int

DECLARE @MapeoOrigenDeDatosTabla TABLE (T_ID Int, T_OldId Int);
DECLARE @MapeoOrigenDeDatosVista TABLE (V_ID Int, V_OldId Int);
--DECLARE @MapeoFormulario TABLE (F_ID Int, F_OldId Int);
DECLARE @MapeoAtributo TABLE (A_ID Int, A_OldId Int);


---------------------
--- Proyecto
---------------------

--Obtencion de claves
SELECT  TOP (1)  @IdProyecto = IdProyecto
	FROM    H_Proyecto
	where	H_IdProyecto = @H_IdProyecto


SELECT  TOP (1)  @IdProceso = IdProceso
	FROM    Proceso
	where	IdProyecto = @IdProyecto

SELECT  TOP (1)  @IdOrigenDeDatos = IdOrigenDeDatos
	FROM    OrigenDeDatos
	where	IdProyecto = @IdProyecto

select IdFormulario into #Formularios from Formulario 
	where IdFormulario in (select IdFormulario from Actividad where IdProceso = @IdProceso)
	
	/*
	print 'proyecto'
	print @IdProyecto
	print 'proceso'
	print @IdProceso
	print 'odd'
	print @IdOrigenDeDatos
	*/

--Actividad
delete from Actividad
--select * from Actividad 
where IdProceso = @IdProceso

--Formulario
/*
delete from Formulario
--select * from Formulario 
where IdFormulario in (select IdFormulario from #Formularios)
*/
--Atributos - Tablas
delete from Atributo
--select * from Atributo
	where IdOrigenDeDatosTabla is not null
		and IdProceso = @IdProceso

--Atributos - Vistas
delete from Atributo
--select * from Atributo
	where IdOrigenDeDatosVista is not null
		and IdProceso = @IdProceso

--Atributos - Pectra
delete from Atributo
--select * from Atributo
	where IdProceso = @IdProceso

--OrigenDeDatosTabla
delete from OrigenDeDatosTabla
--select *  from OrigenDeDatosTabla 
	where IdOrigenDeDatos = @IdOrigenDeDatos
	
--OrigenDeDatosVista
delete from OrigenDeDatosVista
--select *  from OrigenDeDatosVista 
	where IdOrigenDeDatos = @IdOrigenDeDatos	

--OrigenDeDatos
delete from OrigenDeDatos
--select *  from OrigenDeDatos 
	where IdOrigenDeDatos = @IdOrigenDeDatos		

--Proceso
delete from Proceso 
--select *  from Proceso 
	where IdProceso= @IdProceso 


	/*
	update Proyecto
	set Nombre = Nombre + '_' + cast(@H_IdProyecto as varchar(10))
	where IdProyecto = @IdProyecto
	*/
/*


INSERT INTO		Proyecto
                         ( Nombre, FechaInicio, FechaFinEstimada, FechaFin, Responsable, Estado)
--SELECT  TOP (1)  Nombre + '_Restaurado_De_' + replace(replace(replace(convert(nvarchar(19), fechaBack, 20), ':','_'), '-','_'), ' ','_')
SELECT  TOP (1)  Nombre + '_Restaurado_de_' + convert(nvarchar(19), IdProyecto, 20) + '.' + convert(nvarchar(19), [version], 20)
, getdate(), FechaFinEstimada, FechaFin, Responsable, Estado
FROM    H_Proyecto
where	H_IdProyecto = @H_IdProyecto

set @IdProyecto = @@IDENTITY
*/

---------------------
---- OrigenDeDatos
---------------------

SELECT TOP (1) @H_IdOrigenDeDatos = H_IdOrigenDeDatos
FROM    H_OrigenDeDatos
where	H_IdProyecto = @H_IdProyecto

if @H_IdOrigenDeDatos is not null 
	BEGIN
		INSERT INTO OrigenDeDatos
								 (IdProyecto, Servidor, UsaSeguridadIntegrada, Usuario, Password, NombreBaseDeDatos, Observaciones)
		SELECT      @IdProyecto, Servidor, UsaSeguridadIntegrada, Usuario, Password, NombreBaseDeDatos, Observaciones
		FROM        H_OrigenDeDatos
		WHERE		H_IdOrigenDeDatos = @H_IdOrigenDeDatos

		set @IdOrigenDeDatos = @@IDENTITY;

	END


---------------------
---- OrigenDeDatosTabla
---------------------

if @H_IdOrigenDeDatos is not null 
	BEGIN

		MERGE INTO OrigenDeDatosTabla
		USING H_OrigenDeDatosTabla AS cf
		ON 1 = 0 -- Ensure never match - therefore an Insert
		WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto THEN
  
		INSERT		 (IdOrigenDeDatos, NombreTabla)
		values       (@IdOrigenDeDatos, cf.NombreTabla)
  
		Output inserted.IdOrigenDeDatosTabla, cf.IdOrigenDeDatosTabla INTO 
		@MapeoOrigenDeDatosTabla(T_Id, T_OldId);

		
		--select 'insert into @MapeoOrigenDeDatosTabla select ' + cast(T_Id as varchar(290)) + ', ' + cast(T_OldId as varchar(20)) from @MapeoOrigenDeDatosTabla order by 1 desc


	END
	
---------------------
---- OrigenDeDatosVista
---------------------

if @H_IdOrigenDeDatos is not null 
	BEGIN

		MERGE INTO OrigenDeDatosVista
		USING H_OrigenDeDatosVista AS cf
		ON 1 = 0 -- Ensure never match - therefore an Insert
		WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto THEN
  
		INSERT		 (IdOrigenDeDatos, NombreVista)
		values       (@IdOrigenDeDatos, cf.NombreVista)
  
		Output inserted.IdOrigenDeDatosVista, cf.IdOrigenDeDatosVista INTO 
		@MapeoOrigenDeDatosVista(V_Id, V_OldId);

		  
		--select 'insert into @MapeoOrigenDeDatosVista select ' + cast(V_Id as varchar(290)) + ', ' + cast(V_OldId as varchar(20)) from @MapeoOrigenDeDatosVista order by 1 desc

	END

---------------------
---- Proceso
---------------------

SELECT TOP (1) @H_IdProceso = H_IdProceso
FROM    H_Proceso
where	H_IdProyecto = @H_IdProyecto


if @H_IdProceso is not null 
	BEGIN
		INSERT INTO Proceso
								 (IdProyecto, Nombre, Descripcion, Definicion, NombreArchivo)
		SELECT      TOP (1) @IdProyecto, Nombre, Descripcion, Definicion, NombreArchivo
		FROM        H_Proceso 
		WHERE		H_IdProceso = @H_IdProceso
	
	
		set @IdProceso = @@IDENTITY;
	END
	

	
---------------------
---- Formulario
---------------------
if @H_IdProceso is not null 
	BEGIN

	UPDATE Formulario 
		set		Nombre = H.Nombre,
				Definicion = H.Definicion,
				Titulo = H.Titulo
		FROM Formulario F
				inner join [H_Formulario] H
				on H.IdFormulario = F.IdFormulario
		WHERE H_IdProyecto = @H_IdProyecto

	/*
		MERGE INTO Formulario
		USING H_Formulario AS cf
		ON 1 = 0 -- Ensure never match - therefore an Insert
		WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto THEN
  
		INSERT		 (Nombre, Definicion, Finalizado)
		values       (cf.Nombre, cf.Definicion, cf.Finalizado)
  
		Output inserted.IdFormulario, cf.H_IdFormulario INTO 
		@MapeoFormulario(F_Id, F_OldId);
		*/
	END

		
---------------------
---- Actividad
---------------------
if @H_IdProceso is not null 
/*
	BEGIN
		INSERT INTO Actividad
				(IdProceso, IdFormulario, IdActividadPectra, DescripcionActividadPectra)

		SELECT	@IdProceso, [F_ID] as IdFormulario, HA.IdActividadPectra, HA.DescripcionActividadPectra 
		FROM	[H_Actividad] HA
			left outer join H_Formulario HF on HF.[IdFormulario] = HA.[IdFormulario]
			and HF.H_IdProyecto = HA.H_IdProyecto
			left outer join @MapeoFormulario MF
		on MF.F_OldId = HF.H_IdFormulario
		WHERE	HA.H_IdProyecto = @H_IdProyecto 
	END
	*/
	BEGIN
		INSERT INTO Actividad
			(IdProceso, IdFormulario, IdActividadPectra, DescripcionActividadPectra)

			SELECT	@IdProceso, HA.IdFormulario, HA.IdActividadPectra, HA.DescripcionActividadPectra 
			FROM	[H_Actividad] HA
			WHERE	HA.H_IdProyecto = @H_IdProyecto 
	END

	
---------------------
---- Atributo
---------------------

if @H_IdProceso is not null 
	BEGIN
	----------------
	-- Att de Pectra
	----------------

		MERGE INTO Atributo
			USING H_Atributo AS cf
			ON 1 = 0 -- Ensure never match - therefore an Insert
			WHEN NOT MATCHED AND cf.H_IdProyecto = @H_IdProyecto 
							 AND cf.TipoAtributo = 'pectra'		THEN
  
			INSERT		 (IdProceso,  Nombre, TipoAtributo)
			values       (@IdProceso, cf.Nombre, cf.TipoAtributo)
			  
			Output inserted.IdAtributo, cf.IdAtributo INTO 
			@MapeoAtributo(A_Id, A_OldId);


			--select 'insert into @MapeoAtributo select ' + cast(A_Id as varchar(290)) + ', ' + cast(A_OldId as varchar(20)) from @MapeoAtributo order by 1 desc

	----------------
	-- Att de Base de Datos
	----------------
	/*
	INSERT INTO Atributo
		(IdProceso, IdOrigenDeDatosTabla, IdOrigenDeDatosVista, IdAtributoRelacionado, Nombre, TipoAtributo, TipoDeDato, EsClavePrimaria, Identidad, PermiteNulo)

	SELECT @IdProceso, T_ID as IdOrigenDeDatosTabla, V_ID as IdOrigenDeDatosVista, A_ID as IdAtributoRelacionado, HA.Nombre, HA.TipoAtributo, HA.TipoDeDato, HA.EsClavePrimaria, HA.Identidad, HA.PermiteNulo
		  FROM [H_Atributo] HA

		  left outer join @MapeoOrigenDeDatosTabla	MT on HA.IdOrigenDeDatosTabla = MT.T_OldId
		  left outer join @MapeoOrigenDeDatosVista	MV on HA.IdOrigenDeDatosVista = MV.V_OldId
		  left outer join @MapeoAtributo			MA on HA.IdAtributoRelacionado = MA.A_OldId

		  WHERE  HA.H_IdProyecto = @H_IdProyecto
		  AND HA.TipoAtributo = 'Database'
		  Order by 1 desc
  */


	SELECT @IdProceso as IdProceso, T_ID as IdOrigenDeDatosTabla, V_ID as IdOrigenDeDatosVista, A_ID as IdAtributoRelacionado, HA.Nombre, HA.TipoAtributo, HA.TipoDeDato, HA.EsClavePrimaria, HA.Identidad, HA.PermiteNulo, HA.IdAtributo
		    into #TempAttDB
			FROM [H_Atributo] HA

		  left outer join @MapeoOrigenDeDatosTabla	MT on HA.IdOrigenDeDatosTabla = MT.T_OldId
		  left outer join @MapeoOrigenDeDatosVista	MV on HA.IdOrigenDeDatosVista = MV.V_OldId
		  left outer join @MapeoAtributo			MA on HA.IdAtributoRelacionado = MA.A_OldId
		
		  WHERE  HA.H_IdProyecto = @H_IdProyecto
		  AND HA.TipoAtributo = 'Database'


		  
		MERGE INTO Atributo
			USING #TempAttDB AS cf
			ON 1 = 0 -- Ensure never match - therefore an Insert
			WHEN NOT MATCHED 	THEN
  
			INSERT		 (IdProceso, IdOrigenDeDatosTabla, IdOrigenDeDatosVista, IdAtributoRelacionado, Nombre, TipoAtributo, TipoDeDato, EsClavePrimaria, Identidad, PermiteNulo)
			values       (cf.IdProceso, cf.IdOrigenDeDatosTabla, cf.IdOrigenDeDatosVista, cf.IdAtributoRelacionado, cf.Nombre, cf.TipoAtributo, cf.TipoDeDato, cf.EsClavePrimaria, cf.Identidad, cf.PermiteNulo)
			  
			Output inserted.IdAtributo, cf.IdAtributo INTO 
			@MapeoAtributo(A_Id, A_OldId);



			select 'insert into @MapeoAtributo select ' + cast(A_Id as varchar(290)) + ', ' + cast(A_OldId as varchar(20)) from @MapeoAtributo order by 1 desc
	END


-----------------------------------
-- Actulizacion de Campo Definicino de los Formularios
-----------------------------------
	
DECLARE @MapeoA varchar(max)
DECLARE @MapeoT varchar(max)

set @MapeoA = CAST((select A_Id, A_OldId from @MapeoAtributo FOR XML raw('row'),root('root') ) AS VARCHAR(MAX));
set @MapeoT = CAST((select T_Id, T_OldId from @MapeoOrigenDeDatosTabla FOR XML raw('row'),root('root') ) AS VARCHAR(MAX));


DECLARE @Formularios				TABLE (Id int identity(1,1), IdFormulario int,Procesado	bit DEFAULT 0)
DECLARE @IdFormularioAReemplazar	INT

INSERT @Formularios (IdFormulario)
	SELECT IdFormulario from Actividad 
		WHERE IdProceso = @IdProceso

While (Select Count(*) From @Formularios Where Procesado = 0) > 0
	Begin
		Update top (1) @Formularios Set Procesado = 1, @IdFormularioAReemplazar = IdFormulario WHERE Procesado = 0
		EXEC H_ActualizarDefinicionFormulario @IdFormularioAReemplazar, @MapeoT, '', @MapeoA
		--PRINT 'SE ACTUALIZA FORMULARIO : ' + cast(@IdFormularioAReemplazar as varchar(20))
		
	End
GO
PRINT N'Creando [dbo].[z_EliminarProyecto]...';


GO
Create procedure z_EliminarProyecto
(
@IdProyecto int
)
AS

select IdFormulario into #Formularios from Formulario 
	where IdFormulario in (select IdFormulario from Actividad where IdProceso in ( 
		select IdProceso from proceso
		where IdProyecto = @IdProyecto
		)
)

--Actividad
delete from Actividad
where IdProceso in ( 
		select IdProceso from proceso
		where IdProyecto = @IdProyecto
		)


--Formulario
delete from Formulario
where IdFormulario in (select IdFormulario from #Formularios)

--Atributo
delete from Atributo
where IdProceso in ( 
		select IdProceso from proceso
		where IdProyecto = @IdProyecto
		)
		and TipoAtributo = 'database'

delete from Atributo
where IdProceso in ( 
		select IdProceso from proceso
		where IdProyecto = @IdProyecto
		)
		and TipoAtributo = 'pectra'

--OrigenDeDatosVista
delete from [dbo].[OrigenDeDatosVista]
where IdOrigenDeDatos in (
select IdOrigenDeDatos from [dbo].[OrigenDeDatos]
	where  IdProyecto = @IdProyecto)

--OrigenDeDatosTabla
delete from [dbo].[OrigenDeDatosTabla]
where IdOrigenDeDatos in (
select IdOrigenDeDatos from [dbo].[OrigenDeDatos]
	where  IdProyecto = @IdProyecto)

--OrigenDeDatos
delete from [dbo].[OrigenDeDatos]
	where  IdProyecto = @IdProyecto

--Proceso
delete	from proceso
where IdProyecto in (
	(select IdProyecto from Proyecto
	where IdProyecto  = @IdProyecto)
	)

--Proyecto
delete from Proyecto
	where IdProyecto  = @IdProyecto
GO
PRINT N'Actualizando [dbo].[Formulario_d]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Formulario_d]';


GO
PRINT N'Actualizando [dbo].[Formulario_g_ByIdProceso]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Formulario_g_ByIdProceso]';


GO
PRINT N'Actualizando [dbo].[Formulario_g_ByIdProyecto]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Formulario_g_ByIdProyecto]';


GO
PRINT N'Actualizando [dbo].[Formulario_s]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Formulario_s]';


GO
PRINT N'Actualizando [dbo].[Proyecto_d]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Proyecto_d]';


GO
PRINT N'Actualizando [dbo].[Proyecto_u]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Proyecto_u]';


GO
PRINT N'Actualizando [dbo].[Proyecto_uEstado]...';


GO
EXECUTE sp_refreshsqlmodule N'[dbo].[Proyecto_uEstado]';


GO
PRINT N'Actualización completada.';


GO
PRINT N'Actualizando tabla ExpresionRegular'

SET IDENTITY_INSERT [dbo].[ExpresionRegular] ON 
GO

MERGE INTO ExpresionRegular AS Target 
USING (VALUES 
(1, N'Alfanuméricos (abc123)', N'^[a-zA-Z0-9]+$'),
(2, N'Alfanuméricos español (abc123ñá)', N'^[a-z A-Záãâäàéêëèíîïìóõôöòúûüùçñ 0-9 _''.-]+$'),
(3, N'Cuil/Cuit (22-45879685-5 / 30-12345678-9)', N'^(20{1}|^23|^24|^27|^A30|^33|^34)+(\-\d{8}\-\d{1})$'),
(4, N'DNI (30123654)', N'^[1-9][0-9]{7}$|^[1-9][0-9]{6}$'),
(5, N'E-Mail (info@pectra.com)', N'^([0-9a-zA-Z]+([_.-]?[0-9a-zA-Z]+)*@@[0-9a-zA-Z]+[0-9,a-z,A-Z,.,-]*(.){1}[a-zA-Z]{2,4})+$'),
(6, N'Fecha/Hora (MM/DD/AAAA hh:mm:ss am/pm)', N'^(((((0[13578])|([13578])|(1[02]))[\-\/\s]?((0[1-9])|([1-9])|([1-2][0-9])|(3[01])))|((([469])|(11))[\-\/\s]?((0[1-9])|([1-9])|([1-2][0-9])|(30)))|((02|2)[\-\/\s]?((0[1-9])|([1-9])|([1-2][0-9]))))[\-\/\s]?\d{4})(\s(((0[1-9])|([1-9])|(1[0-2]))\:([0-5][0-9])((\s)|(\:([0-5][0-9])\s))([AM|PM|am|pm]{2,2})))?$'),
(7, N'Fecha/Hora (DD/MM/AAAA hh:mm:ss)', N'^((((31\/(0?[13578]|1[02]))|((29|30)\/(0?[1,3-9]|1[0-2])))\/(1[6-9]|[2-9]\d)?\d{2})|(29\/0?2\/(((1[6-9]|[2-9]\d)?(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))))|(0?[1-9]|1\d|2[0-8])\/((0?[1-9])|(1[0-2]))\/((1[6-9]|[2-9]\d)?\d{2})) (20|21|22|23|[0-1]?\d):[0-5]?\d:[0-5]?\d$'),
(8, N'Fecha (AAAA-MM-DD)', N'^\d{4}-(0[0-9]|1[0,1,2])-([0,1,2][0-9]|3[0,1])$'),
(9, N'Fecha (DD/MM/AAAA)', N'^((((31\/(0?[13578]|1[02]))|((29|30)\/(0?[1,3-9]|1[0-2])))\/(1[6-9]|[2-9]\d)?\d{2})|(29\/0?2\/(((1[6-9]|[2-9]\d)?(0[48]|[2468][048]|[13579][26])|((16|[2468][048]|[3579][26])00))))|(0?[1-9]|1\d|2[0-8])\/((0?[1-9])|(1[0-2]))\/((1[6-9]|[2-9]\d)?\d{2}))$'),
(10, N'Fecha (MM/DD/AAAA)', N'^(((0?[1-9]|1[012])\/(0?[1-9]|1\d|2[0-8])|(0?[13456789]|1[012])\/(29|30)|(0?[13578]|1[02])\/31)\/(19|[2-9]\d)\d{2}|0?2\/29\/((19|[2-9]\d)(0[48]|[2468][048]|[13579][26])|(([2468][048]|[3579][26])00)))$'),
(11, N'Hora (hh:mm:ss)', N'^(([0-1]?[0-9])|([2][0-3])):([0-5]?[0-9])(:([0-5]?[0-9]))?$'),
(12, N'Hora (am/pm)', N'^([1-9]|1[0-2]|0[1-9]){1}(:[0-5][0-9][aApP][mM]){1}$'),
(13, N'Números (0.000,00)', N'^(?!0\.00)\d{1,3}(\.\d{3})*(,\d{1,4})?$'),
(14, N'Números (1234)', N'^[0-9]*$'),
(15, N'Números con espacios (12 345 67)', N'^[0-9 ]+$'),
(16, N'Números con negativos (1234 / -1234)', N'^-?\d+$'),
(17, N'Números decimales (000.000)', N'^\d*[0-9](\.\d*[0-9])?$'),
(18, N'Números decimales (000,000)', N'^\d*[0-9](\,\d*[0-9])?$'),
(19, N'Número telefónico (250-555-4542)', N'^[2-9]\d{2}-\d{3}-\d{4}$'),
(20, N'Número telefónico (+54 9 152123456 / 011 4444 4545)', N'^\+?\d{1,4}?[-.\s]?\(?\d{1,3}?\)?[-.\s]?\d{1,4}[-.\s]?\d{1,4}[-.\s]?\d{1,9}$'),
(21, N'Letras con espacios (abc def)', N'^[a-zA-Z ]+$'),
(22, N'Letras sin espacios (abcdef)', N'^[a-zA-Z]+$'),
(23, N'Porcentaje % (00.00 - 100.00)', N'^-?[0-9]{0,2}(\.[0-9]{1,2})?$|^-?(100)(\.[0]{1,2})?$')
) 
AS Source (IdExpresionRegular, Nombre, Expresion) 
ON Target.IdExpresionRegular = Source.IdExpresionRegular 

WHEN MATCHED THEN 
UPDATE SET Nombre = Source.Nombre,
    Expresion = Source.Expresion 

WHEN NOT MATCHED BY TARGET THEN 
INSERT (IdExpresionRegular, Nombre, Expresion) 
VALUES (IdExpresionRegular, Nombre, Expresion) 
 
WHEN NOT MATCHED BY SOURCE THEN 
DELETE;

GO

SET IDENTITY_INSERT [dbo].[ExpresionRegular] OFF
GO

